/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config.sorting;

import java.io.File;
import java.util.Comparator;
import mezz.jei.config.sorting.MappedSortingConfig;
import mezz.jei.config.sorting.serializers.SortingSerializers;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IIngredientListElementInfo;
import net.minecraft.item.ItemStack;

public class IngredientTypeSortingConfig
extends MappedSortingConfig<IIngredientListElementInfo<?>, String> {
    public IngredientTypeSortingConfig(File file) {
        super(file, SortingSerializers.STRING, IngredientTypeSortingConfig::getIngredientType);
    }

    public static String getIngredientType(IIngredientListElementInfo<?> info) {
        IIngredientListElement<?> element = info.getElement();
        Object ingredient = element.getIngredient();
        Class<?> ingredientClass = ingredient.getClass();
        return IngredientTypeSortingConfig.getIngredientType(ingredientClass);
    }

    public static String getIngredientType(Class<?> ingredientClass) {
        return ingredientClass.getName();
    }

    @Override
    protected Comparator<String> getDefaultSortOrder() {
        String itemStackIngredientType = IngredientTypeSortingConfig.getIngredientType(ItemStack.class);
        Comparator<String> itemStackFirst = Comparator.comparing(s -> s.equals(itemStackIngredientType)).reversed();
        Comparator naturalOrder = Comparator.naturalOrder();
        return itemStackFirst.thenComparing(naturalOrder);
    }
}

